#ifndef __HISTORY____H__
#define __HISTORY____H__

#ifdef __cplusplus
extern "C"
{
#endif#pragma once

#include "framework.h"

	/// <summary>
	/// Initializes module and performs an initial read from disk
	/// </summary>
	void history_start(const char* filePath);
	void history_destroy();

	/// <param name="count">Out parameter: count of history entries</param>
	/// <returns>Caller does not own pointers</returns>
	const char** history_get_entries(int* count);

	/// <summary>
	/// Potentially adds a history entry
	/// </summary>
	void history_add(const char* filePath);

#ifdef __cplusplus
}
#endif

#endif  // !__HISTORY____H__
