#ifndef __CONSTANTS____H__
#define __CONSTANTS____H__

#define DEFAULT_FRAME_MS	20

// in ZX Spectrum pixels
#define SPECTRUM_PAPER_WIDTH	256
#define SPECTRUM_PAPER_HEIGHT	192
#define SPECTRUM_BORDER_WIDTH	48

// by spec
#define SPECTRUM_BORDER_LINES_BEFORE_PAPER	64
#define SPECTRUM_BORDER_LINES_AFTER_PAPER	56

#define SPECTRUM_COLOUR_COUNT	8

#define SPECTRUM_ROM_SIZE		16384
#define SPECTRUM_RAM_SIZE		49152

#define CPU_RUN_MODE_FLAG__EXECUTE	0x01

#define CPU_MAX_DISASSEMBLED_NAME	250

#define UNUSED	0
static const char* UNUSEDSTR = "\0";

#define ULA_PORT_FE	0xFE

#define SPECTRUM_SCREEN_WIDTH	(SPECTRUM_PAPER_WIDTH + 2*SPECTRUM_BORDER_WIDTH)
#define SPECTRUM_SCREEN_HEIGHT	(SPECTRUM_PAPER_HEIGHT + SPECTRUM_BORDER_LINES_BEFORE_PAPER + SPECTRUM_BORDER_LINES_AFTER_PAPER)

#define VISIBLE_BORDER_WIDTH_SIDES        24
#define VISIBLE_BORDER_TOP			      16
#define VISIBLE_BORDER_BOTTOM             16

#define HIDE_TOP_BORDER_COUNT		(SPECTRUM_BORDER_LINES_BEFORE_PAPER - VISIBLE_BORDER_TOP)
#define HIDE_BOTTOM_BORDER_COUNT	(SPECTRUM_BORDER_LINES_AFTER_PAPER - VISIBLE_BORDER_BOTTOM)
#define HIDE_LEFT_BORDER_COUNT		((SPECTRUM_SCREEN_WIDTH - SPECTRUM_PAPER_WIDTH)/2 - VISIBLE_BORDER_WIDTH_SIDES)
#define HIDE_RIGHT_BORDER_COUNT		HIDE_LEFT_BORDER_COUNT

#define VISIBLE_SPECTRUM_TOP_BORDER_COUNT		(SPECTRUM_BORDER_LINES_BEFORE_PAPER - HIDE_TOP_BORDER_COUNT)
#define VISIBLE_SPECTRUM_BOTTOM_BORDER_COUNT	(SPECTRUM_BORDER_LINES_AFTER_PAPER - HIDE_BOTTOM_BORDER_COUNT)

#define VISIBLE_SPECTRUM_SCREEN_WIDTH		(SPECTRUM_SCREEN_WIDTH - HIDE_LEFT_BORDER_COUNT - HIDE_RIGHT_BORDER_COUNT)
#define VISIBLE_SPECTRUM_SCREEN_HEIGHT		(SPECTRUM_SCREEN_HEIGHT - HIDE_TOP_BORDER_COUNT - HIDE_BOTTOM_BORDER_COUNT)

#define VISIBLE_SPECTRUM_LEFT_BORDER_WIDTH	(SPECTRUM_BORDER_WIDTH - HIDE_LEFT_BORDER_COUNT)
#define VISIBLE_SPECTRUM_RIGHT_BORDER_WIDTH	(SPECTRUM_BORDER_WIDTH - HIDE_RIGHT_BORDER_COUNT)

#define MAX_ZOOM		20
#define DEFAULT_ZOOM    3
#define DEFAULT_VOLUME	26

// duration in milliseconds of the one-time initial delay before the frame timer begins
#define VIDEO_DELAY_TIMER_START_MS 500

// video RAM information
#define SPECTRUM_VIDEO_RAM_START 16384
#define SPECTRUM_VIDEO_RAM_DATA_AREA_LENGTH ((SPECTRUM_PAPER_HEIGHT * SPECTRUM_PAPER_WIDTH) / 8)
#define SPECTRUM_VIDEO_RAM_ATTRIBUTE_AREA_START (SPECTRUM_VIDEO_RAM_START + SPECTRUM_VIDEO_RAM_DATA_AREA_LENGTH)
#define SPECTRUM_VIDEO_RAM_ATTRIBUTE_AREA_LENGTH 768
#define SPECTRUM_VIDEO_RAM_LENGTH (SPECTRUM_VIDEO_RAM_DATA_AREA_LENGTH + SPECTRUM_VIDEO_RAM_ATTRIBUTE_AREA_LENGTH)





#define SPECTRUM_VIDEO_RAM_TOP_THIRD_DATA_START SPECTRUM_VIDEO_RAM_START
#define SPECTRUM_VIDEO_RAM_TOP_THIRD_DATA_LENGTH (SPECTRUM_VIDEO_RAM_DATA_AREA_LENGTH/3)
#define SPECTRUM_VIDEO_RAM_TOP_THIRD_ATTRIBUTE_AREA_START SPECTRUM_VIDEO_RAM_ATTRIBUTE_AREA_START
#define SPECTRUM_VIDEO_RAM_TOP_THIRD_ATTRIBUTE_AREA_DATA_LENGTH (SPECTRUM_VIDEO_RAM_ATTRIBUTE_AREA_LENGTH/3)

#define SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_DATA_START (SPECTRUM_VIDEO_RAM_TOP_THIRD_DATA_START + SPECTRUM_VIDEO_RAM_TOP_THIRD_DATA_LENGTH)
#define SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_DATA_LENGTH (SPECTRUM_VIDEO_RAM_DATA_AREA_LENGTH/3)
#define SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_ATTRIBUTE_AREA_START (SPECTRUM_VIDEO_RAM_TOP_THIRD_ATTRIBUTE_AREA_START + SPECTRUM_VIDEO_RAM_TOP_THIRD_ATTRIBUTE_AREA_DATA_LENGTH)
#define SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_ATTRIBUTE_AREA_DATA_LENGTH (SPECTRUM_VIDEO_RAM_ATTRIBUTE_AREA_LENGTH/3)

#define SPECTRUM_VIDEO_RAM_BOTTOM_THIRD_DATA_START (SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_DATA_START + SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_DATA_LENGTH)
#define SPECTRUM_VIDEO_RAM_BOTTOM_THIRD_DATA_LENGTH (SPECTRUM_VIDEO_RAM_DATA_AREA_LENGTH/3)
#define SPECTRUM_VIDEO_RAM_BOTTOM_THIRD_ATTRIBUTE_AREA_START (SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_ATTRIBUTE_AREA_START + SPECTRUM_VIDEO_RAM_MIDDLE_THIRD_ATTRIBUTE_AREA_DATA_LENGTH)
#define SPECTRUM_VIDEO_RAM_BOTTOM_THIRD_ATTRIBUTE_AREA_DATA_LENGTH (SPECTRUM_VIDEO_RAM_ATTRIBUTE_AREA_LENGTH/3)

#endif // !__CONSTANTS____H__
