#ifndef __SOUND_BUFFER____H__
#define __SOUND_BUFFER____H__

#include <SDL.h>

// initialization order:
//
// soundbuffer_set_buffer_default()                 [MANDATORY]
// soundbuffer_override_buffer_size_MS()            [OPTIONAL]
// soundbuffer_preinit()                            [MANDATORY]
// soundbuffer_override_min_trailing_distance_MS()  [OPTIONAL]
// soundbuffer_override_max_trailing_distance_MS()  [OPTIONAL]
// soundbuffer_override_rewind_amount_MS()          [OPTIONAL]
// soundbuffer_override_fastforward_amount_MS()     [OPTIONAL]
// soundbuffer_start()                              [MANDATORY]

// these override sync settings and may disable certain features
void soundbuffer_override_buffer_size_MS(double bufferSizeMs);
void soundbuffer_override_min_trailing_distance_MS(double value);
void soundbuffer_override_max_trailing_distance_MS(double value);
void soundbuffer_override_rewind_amount_MS(double value);
void soundbuffer_override_fastforward_amount_MS(double value);


void soundbuffer_set_buffer_default(Uint16 framems);
void soundbuffer_preinit(Uint32 samplesPerSecond);

void soundbuffer_start();
void soundbuffer_destroy();

void soundbuffer_write(float value);
float soundbuffer_read(Uint8 preferLongResyncs);

void soundbuffer_notify_start_of_frame();
void soundbuffer_notify_end_of_frame();

void soundbuffer_enable_resync_logging();

#endif  // !__SOUND_BUFFER____H__
