#ifndef __SOUND____H__
#define __SOUND____H__

//#define SOUND_DEFAULT_SAMPLE_RATE_PER_SECOND 320000
#define SOUND_DEFAULT_SAMPLE_RATE_PER_SECOND 96000
//#define SOUND_DEFAULT_SAMPLE_RATE_PER_SECOND 22050
//#define SOUND_DEFAULT_SAMPLE_RATE_PER_SECOND 11025
//#define SOUND_DEFAULT_SAMPLE_RATE_PER_SECOND 8000

// user-settable
enum soundMode {
    Auto = 0,
    Static = 1,
    Dynamic = 2
};

enum soundSamplingMode {
    SoundStaticSampling,
    SoundDynamicSampling
};

void sound_set_sampling_mode(enum soundSamplingMode mode);
void sound_set_user_mode(enum soundMode mode);

void sound_start(Uint32 samplesPerSecond, Uint8 volume);
void sound_destroy();

void sound_play();

void sound_add_sample(Uint8 isSpeakerActive, Uint64 totalTStates);

void sound_notify_start_of_frame();
void sound_notify_end_of_frame();

void sound_keydown(SDL_Keysym key);
void sound_handle_state_change();

#endif  // !__SOUND____H__
