#include <SDL.h>
#include "ULABus.h"

#define _ULA_BUS_INACTIVE_VALUE (0xff);

static Uint8 _ulaBusContents = _ULA_BUS_INACTIVE_VALUE;

Uint8 ula_bus_is_supported_address(Uint16 address) {
	switch (address & 0xFF) {
	case 0xFF:
		return 1;
	}

	return 0;
}

void ula_bus_write8(Uint8 value) {
	_ulaBusContents = value;
}

Uint8 ula_bus_read8() {
	return _ulaBusContents;
}

void ula_bus_go_inactive() {
	_ulaBusContents = _ULA_BUS_INACTIVE_VALUE;
}