#ifndef __KEYBOARD____H__
#define __KEYBOARD____H__

#include <SDL.h>

#define KEY_B 0b00010000
#define KEY_H 0b00010000
#define KEY_Y 0b00010000
#define KEY_6 0b00010000
#define KEY_5 0b00010000
#define KEY_T 0b00010000
#define KEY_G 0b00010000
#define KEY_V 0b00010000

#define KEY_N 0b00001000
#define KEY_J 0b00001000
#define KEY_U 0b00001000
#define KEY_7 0b00001000
#define KEY_4 0b00001000
#define KEY_R 0b00001000
#define KEY_F 0b00001000
#define KEY_C 0b00001000

#define KEY_M 0b00000100
#define KEY_K 0b00000100
#define KEY_I 0b00000100
#define KEY_8 0b00000100
#define KEY_3 0b00000100
#define KEY_E 0b00000100
#define KEY_D 0b00000100
#define KEY_X 0b00000100

#define KEY_SYMBOL_SHIFT 0b00000010
#define KEY_L 0b00000010
#define KEY_O 0b00000010
#define KEY_9 0b00000010
#define KEY_2 0b00000010
#define KEY_W 0b00000010
#define KEY_S 0b00000010
#define KEY_Z 0b00000010

#define KEY_SPACE 0b00000001
#define KEY_ENTER 0b00000001
#define KEY_P 0b00000001
#define KEY_0 0b00000001
#define KEY_1 0b00000001
#define KEY_Q 0b00000001
#define KEY_A 0b00000001
#define KEY_CAPS_SHIFT 0b00000001


void keyboard_start();
void keyboard_destroy();

Uint8 keyboard_is_supported_address(Uint16 address);
Uint8 keyboard_read8(Uint16 address);

void keyboard_keyup(SDL_Keysym key);
void keyboard_keydown(SDL_Keysym key);

void keyboard_keyup_by_code(SDL_Keycode key);
void keyboard_keydown_by_code(SDL_Keycode key);

/// <summary>
/// tries to resolve an override string to an SDL keyboard flag
/// </summary>
/// <returns>0 when unsuccessful</returns>
Uint8 keyboard_try_resolve_keysym_from_override(const char* override, SDL_Keycode* sdlKeysymOUT);

#endif  // !__KEYBOARD____H__