#ifndef __KEMPSTON____H__
#define __KEMPSTON____H__

#include <SDL.h>

#define KEMPSTON_UP 0b00001000
#define KEMPSTON_DOWN 0b00000100
#define KEMPSTON_LEFT 0b00000010
#define KEMPSTON_RIGHT 0b00000001
#define KEMPSTON_FIRE 0b00010000

void kempston_start();
void kempston_destroy();

Uint8 kempston_is_supported_address(Uint16 address);
Uint8 kempston_read8(Uint16 address);

// these use SDL keyboard keys
void kempston_keyup(SDL_Keysym key);
void kempston_keydown(SDL_Keysym key);

// these use our internal button definitions
void kempston_buttonup(Uint8 kempstonButton);
void kempston_buttondown(Uint8 kempstonButton);

/// <summary>
/// tries to resolve an override string to a kempston flag
/// </summary>
/// <returns>0 when unsuccessful</returns>
Uint8 kempston_try_resolve_button_flag_from_override(const char* override, Uint8* kempstonFlagOUT);


#endif  // !__KEMPSTON____H__